---
generated_at: 2026-02-03 10:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：14-SQL All Executions（SQL実行一覧）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **UI_SQL_GROUP_SUB_EXECUTION_ENABLEDのデフォルト値**：要確認

## 2) 参照した情報（Evidence一覧）

- E-01: `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/AllExecutionsPage.scala` 行35-593
- E-02: `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/SQLTab.scala` 行24-44
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` No.14
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` No.14
- E-05: `docs/code-to-docs/画面遷移図.md` SQLTab

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパスは/SQL/ | E-02 行25: SparkUITab(sparkUI, "SQL") | ○ |
| C-02 | デフォルトページ（WebUIPage("")） | E-01 行35: WebUIPage("") | ○ |
| C-03 | Running/Completed/Failedの3セクション | E-01 行42-44: 3つのArrayBuffer, 行49-53: ステータス分類 | ○ |
| C-04 | sqlStore.executionsList()でデータ取得 | E-01 行48: sqlStore.executionsList() | ○ |
| C-05 | ページングテーブル（PagedTable継承） | E-01 行254: extends PagedTable[ExecutionTableRowData] | ○ |
| C-06 | デフォルトソートはID | E-01 行256: getTableParameters(request, executionTag, "ID") | ○ |
| C-07 | テーブルカラム: ID/Query ID/Description/Submitted/Duration | E-01 行299-305: headerInfo定義 | ○ |
| C-08 | Running時にRunning/Succeeded/Failed Job IDsを表示 | E-01 行306-310: showRunningJobs && showSucceededJobs && showFailedJobs | ○ |
| C-09 | Failed時にError Messageカラムを表示 | E-01 行319-323: showErrorMessage条件 | ○ |
| C-10 | Sub Execution IDs表示 | E-01 行325-330: showSubExecutions条件 | ○ |
| C-11 | Description内で+detailsが展開可能 | E-01 行476-496: descriptionCellメソッド | ○ |
| C-12 | Job IDリンクがジョブ詳細画面へ遷移 | E-01 行498-499: jobURLメソッド | ○ |
| C-13 | 実行IDリンクがSQL実行詳細画面へ遷移 | E-01 行501-503: executionURLメソッド | ○ |
| C-14 | サマリーにRunning/Completed/Failedの件数表示 | E-01 行164-192: summary NodeSeq | ○ |
| C-15 | セクション折りたたみ機能 | E-01 行91-101: collapseTable onClick | ○ |
| C-16 | Sub Executionグループ化はUI_SQL_GROUP_SUB_EXECUTION_ENABLED設定で制御 | E-01 行38: groupSubExecutionEnabled | ○ |
| C-17 | ページタイトルは"SQL / DataFrame" | E-01 行194: headerSparkPage引数 | ○ |
| C-18 | UI_SQL_GROUP_SUB_EXECUTION_ENABLEDのデフォルトはfalse | **根拠なし（設定ファイル要確認）** | △ |

## 4) 不足情報（Unknown / Missing）
- UI_SQL_GROUP_SUB_EXECUTION_ENABLED設定のデフォルト値について、config定義ファイルを確認する必要がある
  - 候補：`core/src/main/scala/org/apache/spark/internal/config/UI.scala`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な画面仕様はソースコードと一致
- 1: 中リスク - Sub Execution機能の設定デフォルト値の確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] UI_SQL_GROUP_SUB_EXECUTION_ENABLEDのデフォルト値を設定ファイルで確認
- [ ] SQLAppStatusStore.executionsList()の戻り順序（実行ID昇順）が正しいか確認
- [ ] ページングの動作（大量データ時のパフォーマンス）を確認
